<?php
/**
 * Uninstall handler.
 *
 * Runs only when the plugin is deleted from the Plugins screen.
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Settings option name (must match the main plugin).
$of_tb_opt_delete_data = 'of_tb_delete_data_on_uninstall';

$of_tb_delete_data = get_option( $of_tb_opt_delete_data, 'no' ) === 'yes';

if ( ! $of_tb_delete_data ) {
    // Keep data by default.
    return;
}

global $wpdb;

// Remove settings.
delete_option( 'of_tb_mode' );
delete_option( 'of_tb_allow_assign' );
delete_option( 'of_tb_enable_notices' );
delete_option( 'of_tb_categories' );
delete_option( 'of_tb_widget_limit' );
delete_option( 'of_tb_delete_data_on_uninstall' );

// Remove shared data (exact keys).
delete_option( 'of_tb_shared_tasks' );
delete_option( 'of_tb_shared_templates' );
delete_option( 'of_tb_shared_log' );

// Remove per-user data (pattern keys).
$of_tb_patterns = array(
    'of_tb_user_%_tasks',
    'of_tb_user_%_templates',
    'of_tb_user_%_log',
);

foreach ( $of_tb_patterns as $of_tb_pattern ) {
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
    $wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s", $of_tb_pattern ) );
}

// Remove template draft transients.
$of_tb_transients = array(
    '_transient_of_tb_tpl_draft_%',
    '_transient_timeout_of_tb_tpl_draft_%',
);

foreach ( $of_tb_transients as $of_tb_transient_pattern ) {
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
    $wpdb->query( $wpdb->prepare( "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s", $of_tb_transient_pattern ) );
}
