jQuery(function ($) {
  function updateCount($box) {
    var $ta = $box.find("#ofai_meta_desc");
    if (!$ta.length) return;

    var limit = parseInt($box.find(".ofai-count").data("limit"), 10) || 155;
    var text = $ta.val() || "";
    var len = text.length;
    $box.find(".ofai-count").text(len + " / " + limit + " characters");
  }

  function setStatus($box, msg, isError) {
    var $s = $box.find(".ofai-status");
    $s.text(msg || "");
    $s.removeClass("ofai-status-ok ofai-status-error");
    if (msg) {
      $s.addClass(isError ? "ofai-status-error" : "ofai-status-ok");
    }
  }

  // Meta box counter
  $(document).on("keyup change", "#ofai_meta_desc", function () {
    updateCount($(this).closest("#ofai_meta_box, .postbox"));
  });

  // Initialise count on load
  setTimeout(function () {
    updateCount($("#ofai_meta_box").closest(".postbox"));
  }, 200);

  // Generate buttons
  $(document).on("click", ".ofai-generate, .ofai-regenerate", function () {
    var $btn = $(this);
    var postId = $btn.data("post-id");
    var mode = $btn.data("mode") || "generate";
    var $box = $btn.closest(".postbox");

    if (!OFAI || !OFAI.nonce) return;

    setStatus($box, OFAI.i18n.generating, false);

    $.ajax({
      url: OFAI.ajaxUrl,
      type: "POST",
      dataType: "json",
      data: {
        action: "ofai_generate",
        nonce: OFAI.nonce,
        post_id: postId,
        mode: mode
      }
    })
      .done(function (resp) {
        if (!resp || !resp.success) {
          var msg = (resp && resp.data && resp.data.message) ? resp.data.message : OFAI.i18n.error;
          if (msg === "Missing API key.") msg = OFAI.i18n.noKey;
          setStatus($box, msg, true);
          return;
        }
        $("#ofai_meta_desc").val(resp.data.description || "");
        updateCount($box);
        setStatus($box, OFAI.i18n.done, false);
      })
      .fail(function () {
        setStatus($box, OFAI.i18n.error, true);
      });
  });

  // Bulk generation
  var bulk = {
    running: false,
    token: "",
    total: 0,
    processed: 0,
    batchSize: 5,
    errors: []
  };

  function getSelectedTypes() {
    var types = [];
    $(".ofai-bulk-type:checked").each(function () {
      types.push($(this).val());
    });
    return types;
  }

  function setProgress(processed, total) {
    var pct = total > 0 ? Math.round((processed / total) * 100) : 0;
    $(".ofai-progress-bar").css("width", pct + "%");
    $(".ofai-progress-text").text(processed + " of " + total + " processed (" + pct + "%)");
  }

  function showErrors(list) {
    if (!list || !list.length) return;
    var $box = $(".ofai-bulk-errors");
    var $ul = $(".ofai-bulk-errors-list");
    $box.show();
    list.forEach(function (e) {
      $("<li/>").text(e).appendTo($ul);
    });
  }

  function bulkStep() {
    if (!bulk.running) return;

    $.ajax({
      url: OFAI.ajaxUrl,
      type: "POST",
      dataType: "json",
      data: {
        action: "ofai_bulk_process",
        nonce: OFAI.nonce,
        token: bulk.token,
        batch_size: bulk.batchSize
      }
    })
      .done(function (resp) {
        if (!resp || !resp.success) {
          var msg = (resp && resp.data && resp.data.message) ? resp.data.message : OFAI.i18n.error;
          if (msg === "Missing API key.") msg = OFAI.i18n.noKey;
          bulk.running = false;
          $("#ofai-bulk-start").prop("disabled", false);
          $("#ofai-bulk-stop").prop("disabled", true);
          $(".ofai-progress-text").text(msg);
          return;
        }

        bulk.processed = resp.data.processed || bulk.processed;
        setProgress(bulk.processed, bulk.total);

        if (resp.data.errors && resp.data.errors.length) {
          showErrors(resp.data.errors);
        }

        if (resp.data.finished) {
          bulk.running = false;
          $("#ofai-bulk-start").prop("disabled", false);
          $("#ofai-bulk-stop").prop("disabled", true);
          $(".ofai-progress-text").text("Finished. " + bulk.processed + " generated.");
          return;
        }

        // Slight pause between batches to reduce rate limiting.
        setTimeout(bulkStep, 600);
      })
      .fail(function () {
        bulk.running = false;
        $("#ofai-bulk-start").prop("disabled", false);
        $("#ofai-bulk-stop").prop("disabled", true);
        $(".ofai-progress-text").text(OFAI.i18n.error);
      });
  }

  $("#ofai-bulk-start").on("click", function () {
    if (!OFAI || !OFAI.nonce) return;

    $(".ofai-bulk-errors-list").empty();
    $(".ofai-bulk-errors").hide();

    bulk.running = true;
    bulk.processed = 0;
    bulk.token = "";
    bulk.total = 0;
    bulk.batchSize = parseInt($("#ofai-batch-size").val(), 10) || 5;

    $("#ofai-bulk-start").prop("disabled", true);
    $("#ofai-bulk-stop").prop("disabled", false);
    setProgress(0, 0);
    $(".ofai-progress-text").text("Preparing...");

    $.ajax({
      url: OFAI.ajaxUrl,
      type: "POST",
      dataType: "json",
      data: {
        action: "ofai_bulk_init",
        nonce: OFAI.nonce,
        post_types: getSelectedTypes(),
        include_existing: $("#ofai-include-existing").is(":checked") ? "1" : ""
      }
    })
      .done(function (resp) {
        if (!resp || !resp.success) {
          var msg = (resp && resp.data && resp.data.message) ? resp.data.message : OFAI.i18n.error;
          if (msg === "Missing API key.") msg = OFAI.i18n.noKey;
          bulk.running = false;
          $("#ofai-bulk-start").prop("disabled", false);
          $("#ofai-bulk-stop").prop("disabled", true);
          $(".ofai-progress-text").text(msg);
          return;
        }

        bulk.token = resp.data.token || "";
        bulk.total = resp.data.total || 0;

        if (!bulk.total) {
          bulk.running = false;
          $("#ofai-bulk-start").prop("disabled", false);
          $("#ofai-bulk-stop").prop("disabled", true);
          setProgress(0, 0);
          $(".ofai-progress-text").text(OFAI.i18n.nothingToDo || "Nothing to do. All meta descriptions are already generated.");
          return;
        }

        setProgress(0, bulk.total);
        bulkStep();
      })
      .fail(function () {
        bulk.running = false;
        $("#ofai-bulk-start").prop("disabled", false);
        $("#ofai-bulk-stop").prop("disabled", true);
        $(".ofai-progress-text").text(OFAI.i18n.error);
      });
  });

  $("#ofai-bulk-stop").on("click", function () {
    bulk.running = false;
    $("#ofai-bulk-start").prop("disabled", false);
    $("#ofai-bulk-stop").prop("disabled", true);
    $(".ofai-progress-text").text("Stopped.");
  });
});

jQuery(function($){
  $(document).ajaxComplete(function(e,xhr,settings){
    if (!settings || !settings.data) return;
    if (typeof settings.data === 'string' && settings.data.indexOf('ofai') !== -1 && settings.data.indexOf('prepare') !== -1) {
      try {
        var r = xhr.responseJSON;
        var total = r && r.success && r.data && (parseInt(r.data.to_process||r.data.todo||r.data.total||0,10));
        if (!total) {
          var $wrap = $('.wrap');
          ofaiShowNothingToDo($wrap);
        }
      } catch(err) {}
    }
  });
});


/* SEO preview live update */
function ofaiUpdatePreview($wrap) {
  var text = $wrap.find('#ofai_meta_desc').val() || '';
  var $desc = $wrap.find('.ofai-preview-desc');
  if (!$desc.length) return;
  $desc.text(text ? text : 'Meta description preview will appear here.');
}

jQuery(function($){
  // Update on typing
  $(document).on('keyup change', '#ofai_meta_desc', function(){
    var $wrap = $(this).closest('.postbox, #ofai_meta_box');
    ofaiUpdatePreview($wrap);
  });

  // Update after AJAX generation (Generate/Regenerate)
  $(document).ajaxComplete(function(e, xhr, settings){
    if (!settings || !settings.data) return;
    if (typeof settings.data === 'string' && settings.data.indexOf('action=ofai_generate') !== -1) {
      var $wrap = $('#ofai_meta_box').closest('.postbox');
      if ($wrap.length) ofaiUpdatePreview($wrap);
    }
  });

  // Initial
  setTimeout(function(){
    var $wrap = $('#ofai_meta_box').closest('.postbox');
    if ($wrap.length) ofaiUpdatePreview($wrap);
  }, 250);
});
