jQuery(function ($) {
  function setStatus($row, text, isError) {
    var $status = $row.find(".ofopn-status");
    $status.text(text || "");
    $status.removeClass("ofopn-status-ok ofopn-status-error");
    if (text) {
      $status.addClass(isError ? "ofopn-status-error" : "ofopn-status-ok");
    }
  }

  $(document).on("click", ".ofopn-save", function () {
    var $row = $(this).closest("tr.ofopn-note-row");
    var pluginFile = $row.data("ofopn-plugin");
    var note = $row.find(".ofopn-textarea").val();
    var requiredByTheme = $row.find(".ofopn-required-by-theme").is(":checked") ? "1" : "";
    var pricing = $row.find(".ofopn-pricing").val() || "unknown";

    setStatus($row, OFOPN.i18n.saving, false);

    $.ajax({
      url: OFOPN.ajaxUrl,
      type: "POST",
      dataType: "json",
      data: {
        action: "ofopn_save_note",
        nonce: OFOPN.nonce,
        plugin_file: pluginFile,
        note: note,
        required_by_theme: requiredByTheme,
        pricing: pricing
      }
    })
      .done(function (resp) {
        if (!resp || !resp.success) {
          setStatus($row, OFOPN.i18n.saveFail, true);
          return;
        }

        var updatedAt = resp.data.updated_at || "";
        var updatedBy = resp.data.updated_by || "";

        var $meta = $row.find(".ofopn-meta");
        $meta.find(".ofopn-meta-item").remove();

        if (updatedAt) {
          $('<span class="ofopn-meta-item">Last updated: ' + $("<div>").text(updatedAt).html() + "</span>").prependTo($meta);
        }
        if (updatedBy) {
          $('<span class="ofopn-meta-item">Updated by: ' + $("<div>").text(updatedBy).html() + "</span>").prependTo($meta);
        }

        setStatus($row, OFOPN.i18n.saved, false);
        setTimeout(function () {
          setStatus($row, "", false);
        }, 1500);
      })
      .fail(function () {
        setStatus($row, OFOPN.i18n.saveFail, true);
      });
  });
});
