(function () {
  function copyTextToClipboard(text) {
    if (navigator.clipboard && window.isSecureContext) {
      return navigator.clipboard.writeText(text);
    }
    // Fallback
    return new Promise(function(resolve, reject) {
      try {
        var ta = document.createElement('textarea');
        ta.value = text;
        ta.style.position = 'fixed';
        ta.style.top = '-1000px';
        ta.style.left = '-1000px';
        document.body.appendChild(ta);
        ta.focus();
        ta.select();
        var ok = document.execCommand('copy');
        document.body.removeChild(ta);
        ok ? resolve() : reject(new Error('Copy failed'));
      } catch (e) {
        reject(e);
      }
    });
  }

  document.addEventListener('DOMContentLoaded', function () {
    var btn = document.getElementById('ofx-copy-btn');
    var status = document.getElementById('ofx-copy-status');
    var report = document.getElementById('ofx-report');

    if (!btn || !status || !report) { return; }

    btn.addEventListener('click', function () {
      copyTextToClipboard(report.value).then(function () {
        status.textContent = (window.OFX_DIAG && OFX_DIAG.copiedText) ? OFX_DIAG.copiedText : 'Copied';
        window.setTimeout(function () { status.textContent = ''; }, 2500);
      }).catch(function () {
        status.textContent = 'Could not copy. Please select the text and copy manually.';
        window.setTimeout(function () { status.textContent = ''; }, 4000);
      });
    });
  });
})();
