jQuery(function($){
  const $scanBtn = $('#otterfixer-blf-scan');
  const $wrap = $('.otterfixer-blf-progress-wrap');
  const $bar = $('.otterfixer-blf-progress span');
  const $text = $('.otterfixer-blf-progress-text');

  function setProgress(done,total){
    const pct = total ? Math.round((done/total)*100) : 0;
    $bar.css('width', pct + '%');
    $text.text('Checked ' + done + ' of ' + total + ' links...');
  }

  function processBatch(total){
    $.post(OTTERFIXER_BLF.ajaxUrl, {
      action: 'otterfixer_blf_process_batch',
      nonce: OTTERFIXER_BLF.nonce,
      batchSize: 25
    }).done(function(resp){
      if(!resp || !resp.success){
        alert((resp && resp.data && resp.data.message) ? resp.data.message : 'Scan error.');
        $scanBtn.prop('disabled', false);
        return;
      }
      const done = resp.data.done || 0;
      setProgress(done, total);

      if(resp.data.finished){
        $text.text('Scan complete. Reloading results...');
        window.location.reload();
      } else {
        setTimeout(function(){ processBatch(total); }, 150);
      }
    }).fail(function(){
      alert('Scan failed. Please try again.');
      $scanBtn.prop('disabled', false);
    });
  }

  $scanBtn.on('click', function(e){
    e.preventDefault();
    $scanBtn.prop('disabled', true);
    $wrap.show();
    $bar.css('width','0%');
    $text.text('Starting scan...');

    $.post(OTTERFIXER_BLF.ajaxUrl, {
      action: 'otterfixer_blf_start_scan',
      nonce: OTTERFIXER_BLF.nonce
    }).done(function(resp){
      if(!resp || !resp.success){
        alert((resp && resp.data && resp.data.message) ? resp.data.message : 'Could not start scan.');
        $scanBtn.prop('disabled', false);
        return;
      }
      const total = resp.data.total || 0;
      setProgress(0, total);
      if(total === 0){
        $text.text('No internal links found.');
        $scanBtn.prop('disabled', false);
        return;
      }
      processBatch(total);
    }).fail(function(){
      alert('Could not start scan. Please try again.');
      $scanBtn.prop('disabled', false);
    });
  });
});
